# Realtime Scribe デモ環境

ElevenLabs の Scribe v2 Realtime をローカルで試すための構成です。API キーはクライアントに直接埋め込まず、トークン発行サーバーを介して認証します。

## ディレクトリ構成

- `server` : ElevenLabs API からシングルユーストークンを発行する Node.js (Express) サーバー
- `scribe-realtime-client` : マイク入力をブラウザからストリーミングし、リアルタイム文字起こしを表示する React (Vite) クライアント

## 必要環境

- Node.js v18 以上
- ElevenLabs API キー（Scribe Realtime が利用可能なもの）

## サーバーのセットアップ

1. 任意のディレクトリにリポジトリを配置します（以下ではプロジェクトルートを `<project-root>` と表記します）。
2. サーバーディレクトリに移動して依存をインストールします。

   ```bash
   cd <project-root>/server
   npm install
   ```

3. ElevenLabs で取得した API キーを `.env` に設定します（`.env` を作成できない環境では `env.example` が自動で読み込まれます）。

   ```bash
   cp env.example .env  # 作成可能な場合のみ
   # .env 内に ELEVENLABS_API_KEY=<your_api_key> を記載
   ```

4. サーバーを起動します。

   ```bash
   npm run dev   # または npm run start
   ```

サーバーは既定で `http://localhost:3001` で待ち受け、`GET /scribe-token` でシングルユーストークンを返します。必要に応じて `.env` の `PORT` や `CORS_ORIGIN` を変更してください。

## React クライアントのセットアップ

1. クライアントディレクトリに移動し、依存をインストールします。

   ```bash
   cd <project-root>/scribe-realtime-client
   npm install
   ```

2. （任意）サーバーが別ホスト・別ポートの場合は `.env` を作成して `VITE_SERVER_ORIGIN` を指定します。

   ```bash
   echo "VITE_SERVER_ORIGIN=http://localhost:3001" > .env
   ```

3. 開発サーバーを起動します。

   ```bash
   npm run dev
   ```

ブラウザで Vite の URL（既定では `http://localhost:5173`）を開き、マイク利用を許可するとリアルタイムで部分／確定文字起こしが表示されます。

